;Atari Hardware Registers
;File version 1.03
;2005-01-02 17:47:15
;Register names based on PDF specifications

;---------------------------------------
;HARDWARE

;CPU vectors
NMIV    equ     $fffa ;RESET vector
IRQV    equ     $fffc ;IRQ vector
RESETV  equ     $fffe ;NMI vector

;GTIA
GTIA    equ     $d000

HPOSP0  equ     $d000
HPOSP1  equ     $d001
HPOSP2  equ     $d002
HPOSP3  equ     $d003
HPOSM0  equ     $d004
HPOSM1  equ     $d005
HPOSM2  equ     $d006
HPOSM3  equ     $d007
SIZEP0  equ     $d008
SIZEP1  equ     $d009
SIZEP2  equ     $d00a
SIZEP3  equ     $d00b
SIZEM   equ     $d00c
GRAFP0  equ     $d00d
GRAFP1  equ     $d00e
GRAFP2  equ     $d00f
GRAFP3  equ     $d010
GRAFM   equ     $d011
COLPM0  equ     $d012
COLPM1  equ     $d013
COLPM2  equ     $d014
COLPM3  equ     $d015
COLPF0  equ     $d016
COLPF1  equ     $d017
COLPF2  equ     $d018
COLPF3  equ     $d019
COLBAK  equ     $d01a
COLBK   equ     $d01a   ;alias of COLBAK
PRIOR   equ     $d01b
GPRIOR  equ     $d01b   ;alias of PRIOR
VDELAY  equ     $d01c
GRACTL  equ     $d01d
HITCLR  equ     $d01e
CONSOL  equ     $d01f
M0PF    equ     $d000
M1PF    equ     $d001
M2PF    equ     $d002
M3PF    equ     $d003
P0PF    equ     $d004
P1PF    equ     $d005
P2PF    equ     $d006
P3PF    equ     $d007
M0PL    equ     $d008
M1PL    equ     $d009
M2PL    equ     $d00a
M3PL    equ     $d00b
P0PL    equ     $d00c
P1PL    equ     $d00d
P2PL    equ     $d00e
P3PL    equ     $d00f
TRIG0   equ     $d010
TRIG1   equ     $d011
TRIG2   equ     $d012
TRIG3   equ     $d013
PAL     equ     $d014


;Pokey
POKEY   equ     $d200

AUDF1   equ     $d200
AUDF2   equ     $d202
AUDF3   equ     $d204
AUDF4   equ     $d206
AUDC1   equ     $d201
AUDC2   equ     $d203
AUDC3   equ     $d205
AUDC4   equ     $d207
POT0    equ     $d200
POT1    equ     $d201
POT2    equ     $d202
POT3    equ     $d203
POT4    equ     $d204
POT5    equ     $d205
POT6    equ     $d206
POT7    equ     $d207
AUDCTL  equ     $d208
ALLPOT  equ     $d208
POTST   equ     $d208
STIMER  equ     $d209
KBCODE  equ     $d209
SKRES   equ     $d20a
RANDOM  equ     $d20a
POTGO   equ     $d20b
SEROUT  equ     $d20d
SERIN   equ     $d20d
IRQEN   equ     $d20e
IRQST   equ     $d20e
SKCTL   equ     $d20f
SKSTAT  equ     $d20f

;PIA
PIA     equ     $d300

PORTA   equ     $d300
PORTB   equ     $d301
PACTL   equ     $d302
PBCTL   equ     $d303

;ANTIC
ANTIC   equ     $d400

DMACTL  equ     $d400
CHACTL  equ     $d401
DLISTL  equ     $d402
DLISTH  equ     $d403
HSCROL  equ     $d404
VSCROL  equ     $d405
PMBASE  equ     $d407
CHBASE  equ     $d409
WSYNC   equ     $d40a
VCOUNT  equ     $d40b
PENH    equ     $d40c
PENV    equ     $d40d
NMIEN   equ     $d40e
NMIRES  equ     $d40f
NMIST   equ     $d40f

;ANTIC dlisplay list commands
DL_E1   equ     $0
DL_E2   equ     $10
DL_E3   equ     $20
DL_E4   equ     $30
DL_E5   equ     $40
DL_E6   equ     $50
DL_E7   equ     $60
DL_E8   equ     $70
DL_JUMP equ     $01     ;jump to adress and create one empty line
DL_LOOP equ     $41     ;jump to adress and wait for vsync
DL_ADRES equ     $40     ;load memory counter
DL_DLI  equ     $80     ;dli interrupt
DL_HS   equ     $10     ;horizontal scroll
DL_VS   equ     $20     ;vertical scroll
;BASIC GR-codes:
DL_GR0     equ     $02     ;text hi-res mode 40 bytes/line
DL_GR1     equ     $06     ;4 color text mode 20 bytes/line, 1 line V
DL_GR2     equ     $07     ;4 color text mode 20 bytes/line, 2 line V
DL_GR3     equ     $08     ;4 color graphics mode 10 bytes/line, 8 line V
DL_GR4     equ     $09     ;1 color graphics mode 10 bytes/line, 4 line V
DL_GR5     equ     $0a     ;4 color graphics mode, 20 bytes/line, 4 line V
DL_GR6     equ     $0b     ;1 color graphics mode, 20 bytes/line, 2 line V
DL_GR7     equ     $0d     ;4 color graphics mode, 40 bytes/line, 2 line V
DL_GR8     equ     $0f     ;graphics hi-res mode 40 bytes/line
DL_GR12    equ     $04     ;text - 4+1 color, 1 line V
DL_GR15    equ     $0e     ;4 color graphics mode, 40 bytes/line, 1 line V
;modes not supported by BASIC
DL_A3      equ     $03     ;hi-res text mode 8x10 pixel char, 40 bytes/line
DL_A5      equ     $05     ;text - 4+1 color, 2 line V
DL_AC      equ     $0c     ;1 color graphics mode, 20 bytes/line, 1 line V



;------------------------------------------
;USEFUL

;bit mask
OR0     equ     1
OR1     equ     2
OR2     equ     4
OR3     equ     8
OR4     equ     16
OR5     equ     32
OR6     equ     64
OR7     equ     128
AND0    equ     $fe
AND1    equ     $fd
AND2    equ     $fb
AND3    equ     $f7
AND4    equ     $ef
AND5    equ     $df
AND6    equ     $bf
AND7    equ     $7f


;-----------------------------------------------
;hw bits
SKSTAT_KEYPRESS equ OR2 ;key pressed
SKSTAT_SHIFT    equ OR3 ;shift key pressed
SKSTAT_SR_BUSY  equ OR1 ;serial input register busy
SKSTAT_FERR     equ OR7 ;framing error
SKSTAT_KB_OVR   equ OR6 ;keyboard overrun
SKSTAT_SR_OVR   equ OR5 ;serial overrun
SKSTAT_IN_PAD   equ OR4 ;serial input pin

